#include <allegro.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "pbox.h"

PACKET_BOX *packet_box_create(const char *cmd)
{
	PACKET_BOX *pb = (PACKET_BOX *) malloc(sizeof(PACKET_BOX));

	//printf("Creating PB '%s': %p\n", cmd, pb);

	if (pb)
	{
		strncpy(pb->cmd, cmd, 4);
		pb->cmd[4] = 0;
		pb->objects = NULL;
		pb->data = 0;
		pb->size = 5;
	}
	return pb;
}

void packet_box_add_int(PACKET_BOX *pb, int i, int bits)
{
	PB_OBJECT *pbo = (PB_OBJECT *) malloc(sizeof(PB_OBJECT));
	(void) bits;
	
	pbo->data = (int *) malloc(sizeof(int));
	*((int*)pbo->data) = i;

	pbo->type = PB_INT;
	pbo->next = pb->objects;	
	pbo->size = 4;
	pb->objects = pbo;
	
	pb->size += 5;

}

void packet_box_add_string(PACKET_BOX *pb, char *string)
{
	PB_OBJECT *pbo = (PB_OBJECT *) malloc(sizeof(PB_OBJECT));

	pbo->size = strlen(string)+1;
	
	pbo->data = (char *) malloc(sizeof(char) * (pbo->size));
	strncpy(pbo->data, string, pbo->size);
	((char *)pbo->data)[pbo->size-1] = 0;


	pbo->type = PB_STRING;
	pbo->next = pb->objects;	
	
	pb->objects = pbo;
	
	/* one extra for the command, two extra for the size */
	pb->size += pbo->size + 1 + 2;
}

void packet_box_serialize(PACKET_BOX *pb)
{
	PB_OBJECT *pbo = (PB_OBJECT *) pb->objects;
	int i = 0;

	pb->data = (unsigned char *)malloc(pb->size);
	if (!pb->data) 
	{
		pb->size = 0;
		return;
	}

	/* start with the command */
	strncpy(pb->data, pb->cmd, 4);
	pb->data[4] = 0;
	i+= 5;

	while (pbo)
	{		
		pb->data[i++] = pbo->type;

		switch (pbo->type)
		{
			case PB_INT:
			{
				const int v = *((int*)(pbo->data));				
				pb->data[i++] = (v & 0xFF000000) >> 24;
				pb->data[i++] = (v & 0x00FF0000) >> 16;
				pb->data[i++] = (v & 0x0000FF00) >> 8;
				pb->data[i++] = (v & 0x000000FF);
				break;
			}

			case PB_STRING:
			{
				pb->data[i++] = (pbo->size & 0x0000FF00) >> 8;
				pb->data[i++] = (pbo->size & 0x000000FF);
				strncpy((char *)(pb->data) + i, pbo->data, pbo->size);
				pb->data[i + pbo->size-1] = 0;
				i += pbo->size;
			}
		}

		pbo = pbo->next;
	}
}

int packet_box_get_int(PACKET_BOX *pb)
{
        PB_OBJECT *pbo = (PB_OBJECT *) pb->objects;
        PB_OBJECT *prev = NULL;
        while (pbo)
        {
                if (pbo->type == PB_INT)
                {
                        int v = *(int*)(pbo->data);

                        if (prev)
                                prev->next = pbo->next;
                        else
                                pb->objects = pbo->next;

                        free(pbo->data);
                        free(pbo);

                        return v;
                }
                pbo = pbo->next;
        }

        return 0;
}

int packet_box_get_string(PACKET_BOX *pb, char *string, int len)
{
        PB_OBJECT *pbo = (PB_OBJECT *) pb->objects;
        PB_OBJECT *prev = NULL;
        while (pbo)
        {
                if (pbo->type == PB_STRING)
                {
                        strncpy(string, (char *)(pbo->data), len);
                        string[len-1] = 0;

                        if (prev)
                                prev->next = pbo->next;
                        else
                                pb->objects = pbo->next;

                        free(pbo->data);
                        free(pbo);

                        return 1;
                }
                pbo = pbo->next;
        }

        string[0] = 0;

        return 0;
}


PACKET_BOX *packet_box_unserialize(unsigned char *data, int size)
{
        PACKET_BOX *pb;
        int i=5;
        if (size < 5 || data[4] != 0) return NULL;

        pb = packet_box_create(data);
        if (!pb) return NULL;

		strncpy(pb->cmd, data, 4);
		pb->cmd[4] = 0;

        while (i < size)
        {
                switch (data[i++])
                {
                        case PB_INT:
                        {
                                int v = 0;

                                v |= data[i++] << 24;
                                v |= data[i++] << 16;
                                v |= data[i++] << 8;
                                v |= data[i++];

                                packet_box_add_int(pb, v, 4);

                                break;
                        }

                        case PB_STRING:
                        {
                                int len = 0;
                                len |= data[i++] << 8;
                                len |= data[i++];

                                packet_box_add_string(pb, &data[i]);

                                i+= len;
                        }
                }
        }
        return pb;
}




void packet_box_destroy(PACKET_BOX *pb)
{
	PB_OBJECT *pbo = (PB_OBJECT *) pb->objects;

	//printf("Destroying PB %s: %p\n", pb->cmd, pb);
	
	while (pbo)
	{
		PB_OBJECT *tmp = pbo->next;
		switch (pbo->type)
		{
			default:
				if (pbo->data) free(pbo->data);
		}

		free(pbo);
		pbo = tmp;
	}

	if (pb->data) free(pb->data);
	free(pb);
}
